/*------------------------------------------------------------------------------*
 * File Name:  DiademFile.h	 													*
 * Creation: Cheney 2006-12-24													*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Sim 04-18-2007 ADD_RANGE_INFO												*
 *	Hong 07/17/08 v8.0903 FIX_SOME_IMPORT_HAVE_DUPLICATE_SHEET_NAME_NO_AUTO_ENUM*
 *	Hong 04/16/09 QA80-9828-P13 FIX_DIADEM_TIME_FMT_DATA_NOT_CORRECTLY_IMPORTED	*
 *------------------------------------------------------------------------------*/
 
#ifndef _DIADEM_FILE_H
#define _DIADEM_FILE_H


enum
{
	DIADEM_NO_ERROR 						= 0,
	DIADEM_ERR_INVALID_FILE 				= -1,
	DIADEM_ERR_INVALID_LABEL				= -2,
	DIADEM_ERR_INVALID_DATA_TYPE			= -3,
	DIADEM_ERR_EXIST_ILLEGAL_LABEL_VAL		= -4,
	DIADEM_ERR_ILLEGAL_DATA_STORE_TYPE		= -5,
	DIADEM_ERR_FAIL_TO_READ_EXPLICIT_DATA	= -6,
	DIADEM_ERR_INVALID_DATA_FILE			= -7,
	DIADEM_ERR_LACK_CHANNEL_NAME			= -8,
	DIADEM_ERR_UNSUPPORT_FILE				= -9,
	DIADEM_ERR_UNSUPPOORT_CHANNEL_CHANGE	= -10, /// Hong 07/18/07 QA80-9828-P6 REIMPORT_NOT_SUPPORT_SOURCE_FILE_CHANGE_CHANNEL_NUM
};

/// Hong 07/17/08 v8.0903 FIX_SOME_IMPORT_HAVE_DUPLICATE_SHEET_NAME_NO_AUTO_ENUM
enum
{
	DIADEM_RENAME_SHEET_BY_FILENAME			= 0x00000001,
};
/// end FIX_SOME_IMPORT_HAVE_DUPLICATE_SHEET_NAME_NO_AUTO_ENUM

class DiademFile : public stdioFile
{
public:
	DiademFile(LPCTSTR lpszFileName, bool bImport = true);
	~DiademFile();
public:
	BOOL 	Open(LPCTSTR lpszFileName);	
	int 	ReadHeader(TreeNode& trFileNode, TreeNode& trInfo);
	/// Hong 07/17/08 v8.0903 FIX_SOME_IMPORT_HAVE_DUPLICATE_SHEET_NAME_NO_AUTO_ENUM
	//int		Import(Worksheet& wks, TreeNode& trFileNode, TreeNode& trInfo, bool bReadAsBinary = false, int nMode = ASCIMP_MODE_NEW_SHEETS, int nC1 = 0, DWORD dwOption = 0);
	int		Import(Worksheet& wks, TreeNode& trFileNode, TreeNode& trInfo, bool bReadAsBinary = false, int nMode = ASCIMP_MODE_NEW_SHEETS, int nC1 = 0, DWORD dwOption = DIADEM_RENAME_SHEET_BY_FILENAME);
	/// end FIX_SOME_IMPORT_HAVE_DUPLICATE_SHEET_NAME_NO_AUTO_ENUM
	int 	ReadData(Worksheet& wks, TreeNode& trFileNode, bool bReadAsBinary = false, int nMode = ASCIMP_MODE_NEW_SHEETS, int nC1 = 0, DWORD dwOption = 0);
	bool	IsBinarySting(){return m_bBinaryString;} //only for ASCII data
	
	DataRange GetDataRange() { return m_orng; } ///---Sim 04-18-2007 ADD_RANGE_INFO
protected:
	int 	getRecord(TreeNode& trFileNode);
	int 	getGeneralRecord();
	int 	getChannelRecord(TreeNode& trFileNode);
	WORD 	sizeOf();
	int 	getDataType(TreeNode& trDataType);
	int 	getImplicitData(vector& vData, TreeNode& trChannel);
	//for all type except ASC
	int 	getExplicitDataChannel(Worksheet& wks, Dataset& ds, int& nColIndex, int& nChannelIndex, int nColLength, TreeNode& trChannel, TreeNode& trFileNode);
	//for all type except ASC
	int 	getExplicitDataBlock(void* pData, Worksheet& wks, Dataset& ds, int& nColIndex, int& nChannelIndex, int& nBlockChannelIndex, int nColLength, TreeNode& trChannel, TreeNode& trFileNode);
	int 	getASCDataChannel(Worksheet& wks, Dataset& ds, int& nColIndex, int& nChannelIndex, int nColLength, int* pCurrentPos, TreeNode& trChannel, TreeNode& trFileNode, bool bReadAsBinary = false);
	/// Hong 04/16/09 QA80-9828-P13 FIX_DIADEM_TIME_FMT_DATA_NOT_CORRECTLY_IMPORTED
	//void 	handleDateData(Column& col);
	void 	handleDateData(Column& col, bool bNeedOffsetDateData = true);
	/// end FIX_DIADEM_TIME_FMT_DATA_NOT_CORRECTLY_IMPORTED
	void 	handelColumnParameter(Column& col, TreeNode& trChannel, int nChannelIndex, int nColIndex);
	void 	handelColumnUserInfo(Column& col, TreeNode& trChannel);
	void 	getMissingValue(TreeNode& trChannel);
	void 	handelFactorAndOffset(TreeNode& trChannel);
	/// Hong 04/16/09 QA80-9828-P13 FIX_DIADEM_TIME_FMT_DATA_NOT_CORRECTLY_IMPORTED
	//int 	handleColumnInfo(Worksheet& wks, Dataset& ds, TreeNode& trChannel, int nColIndex, int nChannelIndex);
	int 	handleColumnInfo(Worksheet& wks, Dataset& ds, TreeNode& trChannel, int nColIndex, int nChannelIndex, bool bNeedOffsetDateData = true);
	/// end FIX_DIADEM_TIME_FMT_DATA_NOT_CORRECTLY_IMPORTED
private:
	TreeNode	m_trHeader; 		//all info, General and Channls
	TreeNode	m_trChannels; 		//each data Channel's info
	BOOL		m_bLittleEndian;
	string		m_strDataFilePath;
	string		m_strDatFileName;
	LONG 		m_nFileSize;
	int			m_nChannelDatatype;
	double		m_dChannelMissing;
	bool		m_bChannelHasMissing;
	double		m_dOffset;
	double		m_dFactor;
	int 		m_nBlockChannels;
	bool		m_bCommaDecimal;
	bool		m_bBinaryString;  //stroe as binary when ASC type
	
	DataRange m_orng; ///---Sim 04-18-2007 ADD_RANGE_INFO
};


#endif  //_DIADEM_FILE_H
